﻿using System.ComponentModel.DataAnnotations;
using System.Linq;
using PpmsDataService.Models;

namespace PpmsDataService.Models
{
    public class ProviderService
    {
        [Key]
        public string Name { get; set; }

        public string AffiliationName { get; set; }

        public string ProviderName { get; set; }

        public string ProviderAgreementName { get; set; }

        public string SpecialtyName { get; set; }

        public string ProviderSpecialtyName { get; set; }

        public string CareSiteLocationAddress { get; set; }

        public string CareSitePhoneNumber { get; set; }

        public string OrganiztionGroupName { get; set; }

        public string DescriptionOfService { get; set; }

        public string Limitation { get; set; }
       

        //Single
        public virtual IQueryable<Provider> Provider { get; set; }

        //Single
        public virtual IQueryable<Specialty> Specialty { get; set; }

        //Many
        //Service Availabilities
        public virtual IQueryable<ServiceAvailability> ServiceAvailabilities { get; set; }

        //Agreement Providers
        public virtual IQueryable<AgreementProvider> AgreementProviders { get; set; }

    }
}